Imports System.Runtime.InteropServices
Imports System.Text

Module Module1

    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function nucOpenDeviceHandler(ByVal timer As Integer) As Byte
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub nucCloseDeviceHandler()
    End Sub
    <DllImport("NUCLib.dll", CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.Cdecl)> Sub getNUCDevicePath(ByVal value As StringBuilder)
    End Sub
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function isNUCConnected() As Byte
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCVIn() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCIIn() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCVOut() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCIOut() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCTemperature() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCVIgnition() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCPOut() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCVThump() As Single
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCVerMajor() As Byte
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCVerMinor() As Byte
    End Function

    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub restartNUC()
    End Sub
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub restartNUCInBootloaderMode()
    End Sub


    'Flash stuff
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub startNUCLoadingSettings(ByVal to_file As Byte, ByVal compare_with_old As Byte)
    End Sub
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCLoadingSettingsState() As Byte
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCMaxVariableCnt() As Integer
    End Function
    <DllImport("NUCLib.dll", CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.Cdecl)> _
    Function getNUCVariableData(ByVal cnt As UInt32, ByVal name As StringBuilder, ByVal value As StringBuilder, ByVal unit As StringBuilder, ByVal comment As StringBuilder) As Byte
    End Function
    <DllImport("NUCLib.dll", CharSet:=CharSet.Ansi, CallingConvention:=CallingConvention.Cdecl)> _
    Function setNUCVariableData(ByVal cnt As UInt32, ByVal value As String) As Byte
    End Function
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Sub startNUCSaveSettings(ByVal from_file As Byte)
    End Sub
    <DllImport("NUCLib.dll", CallingConvention:=CallingConvention.Cdecl)> Function getNUCSaveSettingsState() As Byte
    End Function

    Sub Main()
        Console.WriteLine("HIT <Esc> TO EXIT!")

        Dim state As Integer

        nucOpenDeviceHandler(1000)
        If (isNUCConnected() = 1) Then
            Console.WriteLine("NUC opened!")
            System.Threading.Thread.Sleep(500) 'it's recommended to give a few miliseconds before the first read otherwise the first read might be 0 

            'the library reads the NUC values in every 1000 msec (once per second)
            'therefore is useless to read them faster from here

            Dim path As StringBuilder = New StringBuilder(1024)
            getNUCDevicePath(path)

            Console.Write(" firmware: ")
            Console.Write(getNUCVerMajor())
            Console.Write(".")
            Console.Write(getNUCVerMinor())
            Console.WriteLine()
            Console.Write(" path: ")
            Console.Write(path)
            Console.WriteLine()
            Console.WriteLine("------------------------------")
        Else
            Console.WriteLine("NUC not found!")
        End If

        Dim ch As ConsoleKey = ConsoleKey.Backspace 'no matter, just not Esc

        While (ch <> ConsoleKey.Escape)
            If (Console.KeyAvailable) Then
                ch = Console.ReadKey().Key
                If (ch <> ConsoleKey.Escape) Then
                    Console.WriteLine("Press again:")
                    Console.WriteLine(" L.Load flash ")
                    Console.WriteLine(" Q.Set flash 1")
                    Console.WriteLine(" W.Set flash 2")
                    Console.WriteLine(" A.Save settings to file")
                    Console.WriteLine(" S.Load settings from file")
                    Dim readch As Char = Console.ReadKey().KeyChar
                    Select Case readch
                        Case "l"c, "L"c
                            Console.WriteLine("Loading flash values. Wait ...")
                            startNUCLoadingSettings(0, 0)
                            Dim mytimeout As Integer = 0
                            While ((getNUCLoadingSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Loading ")
                                Console.Write(getNUCLoadingSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Loading final: ")
                            Console.Write(getNUCLoadingSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                            If (getNUCLoadingSettingsState() = 100) Then 'succesfull
                                Dim var_max As Integer = getNUCMaxVariableCnt()
                                Dim name As StringBuilder = New StringBuilder(256)
                                Dim value As StringBuilder = New StringBuilder(256)
                                Dim unit As StringBuilder = New StringBuilder(256)
                                Dim comment As StringBuilder = New StringBuilder(1024)

                                For i As UInt32 = 0 To var_max
                                    If (getNUCVariableData(i, name, value, unit, comment) <> 0) Then
                                        Console.Write("[")
                                        Console.Write(i)
                                        Console.Write("] ")
                                        Console.Write(name.ToString())
                                        Console.Write("=")
                                        Console.Write(value.ToString())
                                        Console.Write(" ")
                                        Console.Write(unit.ToString())
                                        Console.WriteLine()
                                    End If
                                Next
                            Else
                                Console.WriteLine("    ERROR: ")
                                Console.Write(getNUCLoadingSettingsState())
                            End If
                        Case "a"c, "A"c
                            Console.WriteLine("Saving flash values to file. Wait ...")
                            startNUCLoadingSettings(1, 0)
                            Dim mytimeout As Integer = 0
                            While ((getNUCLoadingSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Loading ")
                                Console.Write(getNUCLoadingSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Loading final: ")
                            Console.Write(getNUCLoadingSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                        Case "s"c, "S"c
                            Console.WriteLine("Loading flash values from file. Wait ...")
                            startNUCSaveSettings(1)
                            Dim mytimeout As Integer = 0
                            While ((getNUCSaveSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Saving ")
                                Console.Write(getNUCSaveSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Saving final: ")
                            Console.Write(getNUCSaveSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                        Case "q"c, "Q"c, "w"c, "W"c
                            If ((readch = "q"c) Or (readch = "Q"c)) Then
                                setNUCVariableData(23, "3111") 'POUT_HIGH_THRESHOLD
                                setNUCVariableData(22, "11111111") 'CONFIG2
                            Else
                                setNUCVariableData(23, "3000") 'POUT_HIGH_THRESHOLD
                                setNUCVariableData(22, "00000000") 'CONFIG2
                            End If

                            startNUCSaveSettings(0)
                            Dim mytimeout As Integer = 0
                            While ((getNUCSaveSettingsState() < 100) And (mytimeout < 20)) 'wait for 10 seconds
                                Console.WriteLine("Saving ")
                                Console.Write(getNUCSaveSettingsState())
                                Console.Write("%")
                                mytimeout = mytimeout + 1
                                System.Threading.Thread.Sleep(500)
                            End While
                            Console.WriteLine("Saving final: ")
                            Console.Write(getNUCSaveSettingsState())
                            Console.Write("%") '100=OK, F0-FF=ERRORCODE
                    End Select
                End If
            Else
                If (isNUCConnected() = 0) Then
                    'nucCloseDeviceHandler();//close it only if you do not want auto reconnect
                    Console.WriteLine("No device")
                Else
                    Console.Write("VIN=")
                    Console.Write(getNUCVIn())
                    Console.Write(" IIn=")
                    Console.Write(getNUCIIn())
                    Console.Write(" VOut=")
                    Console.Write(getNUCVOut())
                    Console.Write(" IOut=")
                    Console.Write(getNUCIOut())
                    Console.Write(" Tmp=")
                    If (getNUCTemperature() >> 0) Then
                        Console.Write("---")
                    Else
                        Console.Write(getNUCTemperature())
                    End If
                    Console.Write(" ")
                    Console.Write(" VIgn=")
                    Console.Write(getNUCVIgnition())
                    Console.Write(" POut=")
                    Console.Write(getNUCPOut())
                    Console.Write(" VTh=")
                    Console.Write(getNUCVThump())
                    Console.Write(" ")
                    Console.WriteLine()
                End If
                System.Threading.Thread.Sleep(1000)
            End If
        End While
        nucCloseDeviceHandler()
    End Sub

End Module
