// OnScreenDisplayPanel.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "OnScreenDisplayPanel.h"

#include "MultiRecoderDemoDlg.h"

#include "LivePropertyDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COnScreenDisplayPanel dialog


COnScreenDisplayPanel::COnScreenDisplayPanel(CWnd* pParent /*=NULL*/)
	: CDialog(COnScreenDisplayPanel::IDD, pParent)
{
	//{{AFX_DATA_INIT(COnScreenDisplayPanel)
	m_editTextYOffset = _T("");
	//}}AFX_DATA_INIT
}


void COnScreenDisplayPanel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COnScreenDisplayPanel)
	DDX_Control(pDX, IDC_EDIT_TEXT_X_OFFSET, m_editTextXOffset);
	DDX_Control(pDX, IDC_EDIT_TEXT_WIDTH, m_editTextWidth);
	DDX_Control(pDX, IDC_EDIT_TEXT_HEIGHT, m_editTextHeight);
	DDX_Control(pDX, IDC_EDIT_TEXT_GLOBAL_TRNSPRNT, m_editTextGlobalTrans);
	DDX_Control(pDX, IDC_EDIT_TEXT_FONT_TRNSPRNT, m_editTextFontTrans);
	DDX_Control(pDX, IDC_STATIC_VIDEO_CLONE_PREVIEW, m_stcClonePreview);
	DDX_Text(pDX, IDC_EDIT_TEXT_Y_OFFSET, m_editTextYOffset);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COnScreenDisplayPanel, CDialog)
	//{{AFX_MSG_MAP(COnScreenDisplayPanel)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COnScreenDisplayPanel message handlers

BOOL COnScreenDisplayPanel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	ULONG inputs = 0;

	// SETTING VIDEO INPUT
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {

		// CREATE CLONE
		//				
		QCAP_CREATE_CLONE( pMainDlg->m_hVideoDevice[ nChannelNum ], m_stcClonePreview.m_hWnd, &pMainDlg->m_hCloneOSDCapDev[ nChannelNum ] );

		if ( pMainDlg->m_hCloneOSDCapDev[ nChannelNum ] != 0 ) {

			QCAP_RUN( pMainDlg->m_hCloneOSDCapDev[ nChannelNum ] );

			QCAP_SET_AUDIO_VOLUME( pMainDlg->m_hCloneOSDCapDev[ nChannelNum ], 0 );
		}
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void COnScreenDisplayPanel::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	if ( pMainDlg->m_hCloneOSDCapDev[ nChannelNum ] != 0 ) {

		QCAP_STOP( pMainDlg->m_hCloneOSDCapDev[ nChannelNum ] );

		QCAP_DESTROY( pMainDlg->m_hCloneOSDCapDev[ nChannelNum ] );

		pMainDlg->m_hCloneOSDCapDev[ nChannelNum ] = 0;
	}
}
