// MyRecordAV.h: interface for the MyRecordAV class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYRECORDAV_H__5F25A30F_B7DE_470E_BEAA_C838B1D85E5A__INCLUDED_)
#define AFX_MYRECORDAV_H__5F25A30F_B7DE_470E_BEAA_C838B1D85E5A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyAV.h"

class MyRecordAV : public MyAV  
{
public:

	MyRecordAV();

	virtual ~MyRecordAV();

	virtual BOOL IsConnected() { return m_bConnect; }
	
	virtual BOOL Connect();	

	virtual BOOL Disconnect();

	void SetChannelID( UINT nChannelID ) { m_nChannelID = nChannelID; }

	UINT GetChannelID() { return m_nChannelID; }

	BOOL SetFilePathName( CHAR * szFileRendererName );

	BOOL SetRecordFormat( ULONG nColorSpaceType, ULONG nWidth, ULONG nHeight, ULONG nBitCount, double dFrameRate );	

	BOOL SetRecordRun();

	BOOL SetRecordStop();

public:

	CString			    m_strFileRendererChangeDevName;			// FILE RENDERER PATH NAME

	DEVICE_HANDLE	    m_hFileRendererDev;						// FILE RENDERER DEVICE

	volatile ULONG		m_nFileRendererRecordState;				// FILE RENDERER RECORD STATE (0 = STOP / 1 = ACQUIRE / 2 = START)

	volatile BOOL		m_bFileRendererChangeNotify;			// FILE RENDERER FILE.CHANGING.EVENT NOTIFY (0 = NONE / 1 = CHANGE)

	SYSTEMTIME			m_sFileRendererChangeSystemTime;		// FILE RENDERER FILE.CHANGING.EVENT SYSTEM TIME

private:	

	UINT			    m_nChannelID;

	BOOL			    m_bIsRecording;

	ULONG				m_nCameraType;

	ULONG				m_nColorSpaceType;

	ULONG				m_nFrameWidth;
	
	ULONG				m_nFrameHeight;

	ULONG				m_nBitCount;

	DOUBLE				m_dFrameRate;

	ULONGLONG			m_nVideoFrameNumber;

	ULONGLONG			m_nAudioFrameNumber;

};

#endif // !defined(AFX_MYRECORDAV_H__5F25A30F_B7DE_470E_BEAA_C838B1D85E5A__INCLUDED_)
