// MyViewManager.cpp: implementation of the MyViewManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "MyViewManager.h"
#include "MyLayout.h"
#include "MyVideoWnd.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

static int IndexTable[][ 2 ] =
{
	{LAYOUT01, 0}, {LAYOUT04, 1}, {LAYOUT09, 2}, {LAYOUT16, 3}, {LAYOUT36, 4}, {LAYOUT64, 5}, {LAYOUT144, 6}
};

static int LayoutIndex(int nLayoutMode)
{
	for (int i = 0; i < sizeof(IndexTable) / sizeof(int[2]); ++i)
	{
		if (IndexTable[ i ][ 0 ] == nLayoutMode)
		{
			return IndexTable[ i ][ 1 ];
		}
	}
	return 0;
};

MyViewManager::MyViewManager()
{
	m_listLayout.RemoveAll();

	MyLayout* pLayout;

	pLayout = new My01Layout;
	pLayout->SetViewManager(this);
	m_listLayout.Add(pLayout);

	pLayout = new My04Layout;
	pLayout->SetViewManager(this);
	m_listLayout.Add(pLayout);

	pLayout = new My09Layout;
	pLayout->SetViewManager(this);
	m_listLayout.Add(pLayout);

	pLayout = new My16Layout;
	pLayout->SetViewManager(this);
	m_listLayout.Add(pLayout);

	pLayout = new My36Layout;
	pLayout->SetViewManager(this);
	m_listLayout.Add(pLayout);
	
	pLayout = new My64Layout;
	pLayout->SetViewManager(this);
	m_listLayout.Add(pLayout);

	pLayout = new My144Layout;
	pLayout->SetViewManager(this);
	m_listLayout.Add(pLayout);

	m_pActiveLayout = NULL;
}

MyViewManager::~MyViewManager()
{
	ReleaseResource();
}

void MyViewManager::ReleaseResource()
{
	for (int i = 0 ; i < m_listLayout.GetSize() ; i++)
	{
		delete m_listLayout[ i ];
	}
}

void MyViewManager::SetVideoWnds(int nMode, MyVideoWnd *listWnd, int nCount)
{
	int nLayoutIndex = LayoutIndex( nMode );

	m_listLayout[ nLayoutIndex ]->SetVideoWnds(listWnd,  nCount);
}

void MyViewManager::Activate(int nMode, BOOL bForce)
{
	int nLayoutIndex = LayoutIndex( nMode );

	MyLayout* pNextLayout = m_listLayout[ nLayoutIndex ];

	if (bForce == FALSE && m_pActiveLayout == pNextLayout) 
	{ 
		return; 
	}

	if (m_pActiveLayout != NULL) 
	{ 
		m_pActiveLayout->Inactive(); 
	}

	m_pActiveLayout = m_listLayout[ nLayoutIndex ];

	if (m_pActiveLayout != NULL) 
	{ 
		m_pActiveLayout->Active(); 
	}
}

void MyViewManager::AddChannelToView(int nMode, int nView, int nChannelNum)
{
	int nLayoutIndex = LayoutIndex( nMode );

	m_listLayout[ nLayoutIndex ]->AddChannelToView(nView, nChannelNum);
}

void MyViewManager::SetLayoutRect(RECT &rect)
{
	int nLayoutSize = m_listLayout.GetSize();

	for (int i = 0; i < nLayoutSize ; ++i)
	{
		m_listLayout[ i ]->SetLayoutRect(rect);
	}

	if (m_pActiveLayout != NULL) 
	{
		m_pActiveLayout->MoveVideoWnds();
	}
}

void MyViewManager::Notify(MyVideoWnd *pVideoWnd, int nMode)
{
    if (m_pActiveLayout != NULL) 
	{
		m_pActiveLayout->Notify(pVideoWnd);
	}
}

void MyViewManager::SwapView(MyVideoWnd *pVideoWnd1, MyVideoWnd *pVideoWnd2)
{
	if (m_pActiveLayout != NULL) 
	{
		m_pActiveLayout->SwapView(pVideoWnd1, pVideoWnd2);
	}
}

void MyViewManager::DelAllChannelFromView(int nMode, int nView)
{
	int nLayoutIndex = LayoutIndex(nMode);

	m_listLayout[ nLayoutIndex ]->DelAllChannelFromView(nView);
}

BOOL MyViewManager::IsWinMaximize()
{
	if (m_pActiveLayout != NULL)
		return m_pActiveLayout->IsWinMaximize();

	return FALSE;
}