#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include "videoinputdlg.h"
#include "ui_videoinputdlg.h"
#include "channelwindow.h"
#include "QCAP.H"

VideoInputDlg::VideoInputDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::VideoInputDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("VIDEO INPUT");

    this->setMinimumSize(225,300);

    this->setMaximumSize(225,300);

    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    switch ( SC510dlg->m_nVideoInput ) {
    case 0:
        ui->radioCOMPOSITE->setChecked(true);
        break;
    case 1:
        ui->radioSVIDEO->setChecked(true);
        break;
    case 2:
        ui->radioHDMI->setChecked(true);
        break;
    case 3:
        ui->radioDVID->setChecked(true);
        break;
    case 4:
        ui->radioCOMPONENTS->setChecked(true);
        break;
    case 5:
        ui->radioDVIA->setChecked(true);
        break;
    case 6:
        ui->radioSDI->setChecked(true);
        break;
    case 7:
        ui->radioAUTO->setChecked(true);
        break;
    default:
        break;
    }
}

VideoInputDlg::~VideoInputDlg()
{
    delete ui;
}

void VideoInputDlg::on_buttonBox_accepted()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( SC510dlg->m_hVideoDevice != 0 )
    {
        if( ui->radioHDMI->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_HDMI);
        }
        if( ui->radioDVID->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_DVI_D);
        }
        if( ui->radioCOMPONENTS->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_COMPONENTS);
        }
        if( ui->radioDVIA->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_DVI_A);
        }
        if( ui->radioSDI->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_HDMI);
        }
        if( ui->radioCOMPOSITE->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_COMPOSITE);
        }
        if( ui->radioSVIDEO->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_SVIDEO);
        }
        if( ui->radioAUTO->isChecked() )
        {
            QCAP_SET_VIDEO_INPUT( SC510dlg->m_hVideoDevice, QCAP_INPUT_TYPE_AUTO);
        }
    }

    qDebug("set video input -> accepted");
}

void VideoInputDlg::on_buttonBox_rejected()
{
    qDebug("set video input -> rejected");
}
