// ShareRecordDialog.cpp : implementation file
//

#include "stdafx.h"
#include "sc510.h"
#include "sc510Dlg.h"
#include "ShareRecordDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShareRecordDialog dialog


CShareRecordDialog::CShareRecordDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CShareRecordDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CShareRecordDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CShareRecordDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShareRecordDialog)
	DDX_Control(pDX, IDC_SHARE_DISPLAY_STATIC, m_staticShareWindow);
	DDX_Control(pDX, IDC_SHARE_CHECK, m_shareCheckGPU1);
	DDX_Control(pDX, IDC_SHARE_STOP_BUTTON, m_btnShareRecordStop1);
	DDX_Control(pDX, IDC_SHARE_START_BUTTON, m_btnShareRecordStart1);
	DDX_Control(pDX, IDC_SHARE_EDIT, m_editShareRecord);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CShareRecordDialog, CDialog)
	//{{AFX_MSG_MAP(CShareRecordDialog)
	ON_BN_CLICKED(IDC_AVI_SHARE_RADIO, OnAviShareRadio)
	ON_BN_CLICKED(IDC_MP4_SHARE_RADIO, OnMp4ShareRadio)
	ON_BN_CLICKED(IDC_CH1_RADIO, OnCh1Radio)
	ON_BN_CLICKED(IDC_CH2_RADIO, OnCh2Radio)
	ON_BN_CLICKED(IDC_CH3_RADIO, OnCh3Radio)
	ON_BN_CLICKED(IDC_CH4_RADIO, OnCh4Radio)
	ON_BN_CLICKED(IDC_SHARE_START_BUTTON, OnShareStartButton)
	ON_BN_CLICKED(IDC_SHARE_STOP_BUTTON, OnShareStopButton)
	ON_BN_CLICKED(IDC_OK_BUTTON, OnOkButton)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShareRecordDialog message handlers

BOOL CShareRecordDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_btnShareRecordStart1.EnableWindow( TRUE );

	m_btnShareRecordStop1.EnableWindow( FALSE );

	// SET PAHT
	::GetModuleFileName( 0, m_pMainDialog->m_strSnapshotPath.GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );
	
	m_pMainDialog->m_strSnapshotPath.ReleaseBuffer();

	INT nPos;

	nPos = m_pMainDialog->m_strSnapshotPath.ReverseFind('\\');
	
	// GET PATH
	m_pMainDialog->m_strSnapshotPath = m_pMainDialog->m_strSnapshotPath.Left( nPos );
	
	m_pMainDialog->m_strRecordPath = m_pMainDialog->m_strSnapshotPath;

	CString strFullPath;
	
	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\ShareRecord.avi"));

	m_editShareRecord.SetWindowText( (LPCTSTR)strFullPath );

	CheckDlgButton( IDC_AVI_SHARE_RADIO, BST_CHECKED );

	CheckDlgButton( IDC_MP4_SHARE_RADIO, BST_UNCHECKED );

	BOOL bIsNoSignal = TRUE;

	// CONFIRM WHETHER HAVE SIGNAL TO RELEVANT INPUT CHANNEL
	//
	for ( ULONG i = 0; i < 4; i++ ) {

		if ( i == 0 ) {

			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) {

				CheckDlgButton( IDC_CH1_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}
		
		if ( i == 1 ) {

			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) {

				CheckDlgButton( IDC_CH2_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}
		
		if ( i == 2 ) {

			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) {

				CheckDlgButton( IDC_CH3_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}

		if ( i == 3 ) {

			if ( m_pMainDialog->m_nVideoWidth[ i ] != 0 ) {

				CheckDlgButton( IDC_CH4_RADIO, BST_CHECKED );

				CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

				CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );

				bIsNoSignal = FALSE;
			}
		}		
	}

	if ( bIsNoSignal ) {
	
		CheckDlgButton( IDC_CH4_RADIO, BST_UNCHECKED );

		CheckDlgButton( IDC_CH2_RADIO, BST_UNCHECKED );

		CheckDlgButton( IDC_CH3_RADIO, BST_UNCHECKED );

		CheckDlgButton( IDC_CH1_RADIO, BST_UNCHECKED );	
	}

	for ( i = 0; i < 4; i++ ) {
		
		if ( i == 0 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {
				
				GetDlgItem( IDC_CH1_RADIO )->EnableWindow( TRUE );
			}
			else {
			
				GetDlgItem( IDC_CH1_RADIO )->EnableWindow( FALSE );
			}
		}

		if ( i == 1 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {

				GetDlgItem( IDC_CH2_RADIO )->EnableWindow( TRUE );
			}
			else {
			
				GetDlgItem( IDC_CH2_RADIO )->EnableWindow( FALSE );
			}
		}

		if ( i == 2 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {

				GetDlgItem( IDC_CH3_RADIO )->EnableWindow( TRUE );
			}
			else {
			
				GetDlgItem( IDC_CH3_RADIO )->EnableWindow( FALSE );
			}
		}

		if ( i == 3 ) {
			
			if ( m_pMainDialog->m_hVideoDevice[ i ] != 0 ) {

				GetDlgItem( IDC_CH4_RADIO )->EnableWindow( TRUE );
			}
			else {
			
				GetDlgItem( IDC_CH4_RADIO )->EnableWindow( FALSE );
			}			
		}
	}	

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CShareRecordDialog::OnAviShareRadio() 
{
	// TODO: Add your control notification handler code here
	
	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\ShareRecord.avi"));

	m_editShareRecord.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_SHARE_RADIO))->GetCheck();

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_SHARE_RADIO))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_SHARE_RADIO))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_SHARE_RADIO))->SetCheck( TRUE ); }
}

void CShareRecordDialog::OnMp4ShareRadio() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	CString strFullPath;

	strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\ShareRecord.mp4"));

	m_editShareRecord.SetWindowText( (LPCTSTR)strFullPath );

	UINT iCheckedAVI_1_1, iCheckedMP4_1_1;

	iCheckedAVI_1_1 = ((CButton*)GetDlgItem(IDC_AVI_SHARE_RADIO))->GetCheck();

	iCheckedMP4_1_1 = ((CButton*)GetDlgItem(IDC_MP4_SHARE_RADIO))->GetCheck();

	if ( iCheckedAVI_1_1 ){ ((CButton*)GetDlgItem(IDC_AVI_SHARE_RADIO))->SetCheck( TRUE ); }

	if ( iCheckedMP4_1_1 ){ ((CButton*)GetDlgItem(IDC_MP4_SHARE_RADIO))->SetCheck( TRUE ); }	
}

void CShareRecordDialog::OnCh1Radio() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = true;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = false;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = false;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = false;
}

void CShareRecordDialog::OnCh2Radio() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = false;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = true;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = false;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = false;	
}

void CShareRecordDialog::OnCh3Radio() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = false;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = false;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = true;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = false;	
}

void CShareRecordDialog::OnCh4Radio() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();

	m_pMainDialog->m_bShareRecordCH[ 0 ] = false;
		
	m_pMainDialog->m_bShareRecordCH[ 1 ] = false;
	
	m_pMainDialog->m_bShareRecordCH[ 2 ] = false;
	
	m_pMainDialog->m_bShareRecordCH[ 3 ] = true;	
}

void CShareRecordDialog::OnShareStartButton() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();	

	m_btnShareRecordStart1.EnableWindow( FALSE );

	m_btnShareRecordStop1.EnableWindow( TRUE );

	GetDlgItem(IDC_OK_BUTTON)->EnableWindow( FALSE );

	m_pMainDialog->m_bShareSupportGPU1_1 = m_shareCheckGPU1.GetCheck();

	INT nChannelNum = -1;

	if ( ((CButton*)GetDlgItem(IDC_CH1_RADIO))->GetCheck() ) { nChannelNum = 0; }

	if ( ((CButton*)GetDlgItem(IDC_CH2_RADIO))->GetCheck() ) { nChannelNum = 1; }

	if ( ((CButton*)GetDlgItem(IDC_CH3_RADIO))->GetCheck() ) { nChannelNum = 2; }

	if ( ((CButton*)GetDlgItem(IDC_CH4_RADIO))->GetCheck() ) { nChannelNum = 3; }

	if ( nChannelNum == -1 ) { return; }

	for ( INT i = 0; i < 4; i++ ) {
		
		if ( i == nChannelNum ) {
			
			m_pMainDialog->m_bShareRecordCH[ i ] = TRUE;
		}
	}
	
	ULONG nVideoWidth = m_pMainDialog->m_nVideoWidth[ nChannelNum ];

	ULONG nVideoHeight =  m_pMainDialog->m_nVideoHeight[ nChannelNum ];

	double dVideoFrameRate = m_pMainDialog->m_dVideoFrameRate[ nChannelNum ];

	UINT iCheckedAVI, iCheckedMP4;

	iCheckedAVI = IsDlgButtonChecked( IDC_AVI_SHARE_RADIO );

	iCheckedMP4 = IsDlgButtonChecked( IDC_MP4_SHARE_RADIO );

	if( iCheckedAVI == BST_CHECKED ) {
			
		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM, 2, 16, 48000, 100 );
	}

	if( iCheckedMP4 == BST_CHECKED ) {

		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 100 );			
	}

	if (m_pMainDialog->m_bShareSupportGPU1_1) {

		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nVideoWidth, nVideoHeight, dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_staticShareWindow.m_hWnd, 1 );
	}
	else {
		
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nVideoWidth, nVideoHeight, dVideoFrameRate, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, m_staticShareWindow.m_hWnd, 1 );
	}

	// SET PAHT
	::GetModuleFileName( 0, m_pMainDialog->m_strSnapshotPath.GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );
	
	m_pMainDialog->m_strSnapshotPath.ReleaseBuffer();

	INT nPos;

	nPos = m_pMainDialog->m_strSnapshotPath.ReverseFind('\\');
	
	// GET PATH
	m_pMainDialog->m_strSnapshotPath = m_pMainDialog->m_strSnapshotPath.Left( nPos );
	
	m_pMainDialog->m_strRecordPath = m_pMainDialog->m_strSnapshotPath;

	CString strFullPath;
	
	if ( iCheckedAVI == BST_CHECKED ) {

		strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\ShareRecord.avi"));
	}
	if ( iCheckedMP4 == BST_CHECKED ) {

		strFullPath = m_pMainDialog->m_strSnapshotPath + CString(_T("\\ShareRecord.mp4"));
	}

	ULONG nStrlen = strFullPath.GetLength();

	CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

	QCAP_START_SHARE_RECORD( 0, psz );

	strFullPath.ReleaseBuffer();	

	m_pMainDialog->m_bIsShareRecord = TRUE;	
}

void CShareRecordDialog::OnShareStopButton() 
{
	// TODO: Add your control notification handler code here

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();	

	m_btnShareRecordStart1.EnableWindow( TRUE );

	m_btnShareRecordStop1.EnableWindow( FALSE );

	GetDlgItem( IDC_OK_BUTTON )->EnableWindow( TRUE );

	QCAP_STOP_SHARE_RECORD( 0 );

	m_pMainDialog->m_bIsShareRecord = false;	
}

void CShareRecordDialog::OnOkButton() 
{
	// TODO: Add your control notification handler code here
	
	CDialog::OnOK();
}

void CShareRecordDialog::OnDestroy() 
{
	CDialog::OnDestroy();

	sc510Dlg* m_pMainDialog = (sc510Dlg*)AfxGetMainWnd();	

	m_btnShareRecordStart1.EnableWindow( TRUE );

	m_btnShareRecordStop1.EnableWindow( FALSE );

	QCAP_STOP_SHARE_RECORD( 0 );
	
	// TODO: Add your message handler code here	
}