﻿Imports System.IO

Imports QCAP.NET

Public Class Form1

    Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As UInt32

    Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Declare Function PostMessage Lib "user32" Alias "PostMessageA" (ByVal hWnd As UInt32, ByVal wMsg As UInt32, ByVal wParam As UInt32, ByVal lParam As UInt32) As UInt32

    Declare Function OutputDebugString Lib "kernel32" Alias "OutputDebugStringA" (ByVal message As String)

    Public m_bIsMaximizedForm As Boolean = False

    Public m_bNoSignal As Boolean = False

    Public m_strCurrentDir As String                ' CURRENT WORKING DIRECTORY

    ' CALLBACK FUNCTION
    '
    Public m_pFormatChangedCB As EXPORTS.PF_FORMAT_CHANGED_CALLBACK = Nothing

    Public m_pNoSignalDetectedCB As EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK = Nothing

    Public m_pSignalRemovedCB As EXPORTS.PF_SIGNAL_REMOVED_CALLBACK = Nothing

    Public m_pPreviewVideoCB As EXPORTS.PF_VIDEO_PREVIEW_CALLBACK = Nothing

    Public m_pPreviewAudioCB As EXPORTS.PF_AUDIO_PREVIEW_CALLBACK = Nothing

    Public m_pVideoHardwareEncoderCB As EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK = Nothing

    Public m_cSetupControl As MySetupControl

    Public m_pChannelControl_LIVE As MyChannelControl

    Public m_strChipName As String = "FH8735 PCI"

    Public m_strFormatChangedOutput As String = ""

    Public m_bShowClone As Boolean = False

    ' DEVICE PROPERTY
    '
    Public m_hCapDev As UInt32 = &H0 ' STREAM CAPTURE DEVICE

    Public m_hCloneCapDev As UInt32 = &H0 ' CLONE STREAM CAPTURE DEVICE

    Public m_nVideoWidth As UInt32 = 1920

    Public m_nVideoHeight As UInt32 = 1080

    Public m_dVideoFrameRate As Double = 60.0

    ' FORMAT CHANGED CALLBACK FUNCTION
    '
    Public Function on_process_format_changed(ByVal pDevice As UInt32, ByVal nVideoInput As UInt32, ByVal nAudioInput As UInt32, ByVal nVideoWidth As UInt32, ByVal nVideoHeight As UInt32, ByVal bVideoIsInterleaved As UInt32, ByVal dVideoFrameRate As Double, ByVal nAudioChannels As UInt32, ByVal nAudioBitsPerSample As UInt32, ByVal nAudioSampleFrequency As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        m_nVideoWidth = nVideoWidth

        m_nVideoHeight = nVideoHeight

        m_dVideoFrameRate = dVideoFrameRate

        Dim nVH As UInt32 = 0

        Dim strFrameType As String = " P "

        Dim strVideoInput As String = ""

        Dim strAudioInput As String = ""

        If nVideoInput = 0 Then : strVideoInput = "COMPOSITE" : End If

        If nVideoInput = 1 Then : strVideoInput = "SVIDEO" : End If

        If nVideoInput = 2 Then : strVideoInput = "HDMI" : End If

        If nVideoInput = 3 Then : strVideoInput = "DVI_D" : End If

        If nVideoInput = 4 Then : strVideoInput = "COMPONENTS (YCBCR)" : End If

        If nVideoInput = 5 Then : strVideoInput = "DVI_A (RGB / VGA)" : End If

        If nVideoInput = 6 Then : strVideoInput = "SDI" : End If

        If nVideoInput = 7 Then : strVideoInput = "AUTO" : End If

        If nAudioInput = 0 Then : strAudioInput = "EMBEDDED_AUDIO" : End If

        If nAudioInput = 1 Then : strAudioInput = "LINE_IN" : End If

        If bVideoIsInterleaved = 1 Then : nVH = nVideoHeight / 2 : Else : nVH = nVideoHeight : End If

        If bVideoIsInterleaved = 1 Then : strFrameType = " I " : Else : strFrameType = " P " : End If

        m_strFormatChangedOutput = " INFO : " + nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + dVideoFrameRate.ToString() + " FPS , " + nAudioChannels.ToString() + " CH x " + nAudioBitsPerSample.ToString() + " BITS x " + nAudioSampleFrequency.ToString() + " HZ , " + " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput + " \n"

        ' NO SIGNAL
        '    
        If nVideoWidth = 0 And nVideoHeight = 0 And dVideoFrameRate = 0.0 And nAudioChannels = 0 And nAudioBitsPerSample = 0 And nAudioSampleFrequency = 0 Then

            m_bNoSignal = True

        Else

            m_bNoSignal = False

        End If

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' PREVIEW VIDEO CALLBACK FUNCTION
    '
    Public Function on_process_preview_video_buffer(ByVal pDevice As UInt32, ByVal dSampleTime As Double, ByVal pFrameBuffer As UInt32, ByVal nFrameBufferLen As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' VIDEO HARDWARE ENCODER CALLBACK FUNCTION
    '
    Public Function on_process_hardware_encoder_video_buffer(ByVal pDevice As UInt32, ByVal iRecNum As Long, ByVal dSampleTime As Double, ByVal pStreamBuffer As UInt32, ByVal nStreamBufferLen As UInt32, ByVal bIsKeyFrame As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' PREVIEW AUDIO CALLBACK FUNCTION
    '
    Public Function on_process_preview_audio_buffer(ByVal pDevice As UInt32, ByVal dSampleTime As Double, ByVal pFrameBuffer As UInt32, ByVal nFrameBufferLen As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' NO SIGNAL DETEACTED CALLBACK FUNCTION
    '
    Public Function on_process_no_signal_detected(ByVal pDevice As UInt32, ByVal nVideoInput As UInt32, ByVal nAudioInput As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        OutputDebugString("No Signal Detected  \n")

        m_bNoSignal = True

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    ' SIGNAL REMOVED CALLBACK FUNCTION
    '
    Public Function on_process_signal_removed(ByVal pDevice As UInt32, ByVal nVideoInput As UInt32, ByVal nAudioInput As UInt32, ByVal pUserData As UInt32) As EXPORTS.ReturnOfCallbackEnum

        OutputDebugString(" Signal Removed \n")

        m_bNoSignal = True

        Return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK

    End Function

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        labelNoSignal.Parent = Me

        m_pChannelControl_LIVE = New MyChannelControl()

        m_pChannelControl_LIVE.Parent = Me

        m_pChannelControl_LIVE.Left = 0

        m_pChannelControl_LIVE.Top = 0

        m_pChannelControl_LIVE.Width = Me.Width

        m_pChannelControl_LIVE.Height = Me.Height

        m_pChannelControl_LIVE.Visible = True

        m_pChannelControl_LIVE.Show()

        CloneChannelPanel.Left = Me.Width - 320

        CloneChannelPanel.Top = Me.Height - 240

        CloneChannelPanel.Width = 320

        CloneChannelPanel.Height = 240

        'GET CURRENT DIRECTORY
        '
        m_strCurrentDir = Directory.GetCurrentDirectory()

        HwInitialize()

        ' USER INTERFACE PROGRAMMING (SETUP CONTROL)
        '        
        m_cSetupControl = New MySetupControl()

        m_cSetupControl.m_pMainForm = Me

        ' Associate the code to be executed (event handler) with the event.
        '
        AddHandler m_cSetupControl.FormClosed, AddressOf Me.SetupControlClosed

        m_cSetupControl.Left = Me.Left

        m_cSetupControl.Top = Me.Bottom - 20

        m_cSetupControl.Visible = True

        m_cSetupControl.Show()

    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed

        HwUnInitialize()

    End Sub

    Private Sub SetupControlClosed(ByVal sender As System.Object, ByVal e As System.EventArgs)

        Me.Close()

    End Sub

    Public Sub HwInitialize()

        m_hCapDev = 0

        m_hCloneCapDev = 0

        m_bNoSignal = True

        m_strFormatChangedOutput = ""

        ' CREATE CAPTURE DEVICE            
        '
        EXPORTS.QCAP_CREATE(m_strChipName, 0, m_pChannelControl_LIVE.Handle.ToInt32(), m_hCapDev, 1)

        ' REGISTER FORMAT CHANGED CALLBACK FUNCTION
        ' 
        m_pFormatChangedCB = New EXPORTS.PF_FORMAT_CHANGED_CALLBACK(AddressOf on_process_format_changed)

        EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev, m_pFormatChangedCB, 0)

        ' REGISTER PREVIEW VIDEO CALLBACK FUNCTION
        ' 
        m_pPreviewVideoCB = New EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(AddressOf on_process_preview_video_buffer)

        EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev, m_pPreviewVideoCB, 0)

        ' REGISTER PREVIEW AUDIO CALLBACK FUNCTION
        '
        m_pPreviewAudioCB = New EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(AddressOf on_process_preview_audio_buffer)

        EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev, m_pPreviewAudioCB, 0)

        ' REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
        '
        m_pNoSignalDetectedCB = New EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(AddressOf on_process_no_signal_detected)

        EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev, m_pNoSignalDetectedCB, 0)

        ' REGISTER SIGNAL REMOVED CALLBACK FUNCTION
        '
        m_pSignalRemovedCB = New EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(AddressOf on_process_signal_removed)

        EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev, m_pSignalRemovedCB, 0)

        ' REGISTER VIDEO HARDWARE ENCODER CALLBACK FUNCTION
        '
        m_pVideoHardwareEncoderCB = New EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK(AddressOf on_process_hardware_encoder_video_buffer)

        EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev, 1, m_pVideoHardwareEncoderCB, 0)

        ' SET INPUT
        '
        Dim nInput = EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI

        EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev, nInput)

        ' RUN DEVICE
        '
        EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev, 0, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev, 1, EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

        EXPORTS.QCAP_RUN(m_hCapDev)

        timerCheckSignal.Enabled = True

    End Sub

    Public Sub HwUnInitialize()

        If m_hCloneCapDev <> 0 Then : EXPORTS.QCAP_STOP(m_hCloneCapDev) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev) : End If

        If m_hCapDev <> 0 Then : EXPORTS.QCAP_STOP(m_hCapDev) : EXPORTS.QCAP_DESTROY(m_hCapDev) : End If

    End Sub

    Public Sub ShowCloneVideo(ByVal bShow As Boolean)

        If bShow = True Then

            m_bShowClone = True

            If m_pChannelControl_LIVE.Visible = True Then

                CloneChannelPanel.Visible = True

                If m_hCapDev <> 0 Then

                    EXPORTS.QCAP_CREATE_CLONE(m_hCapDev, CloneChannelPanel.Handle.ToInt32(), m_hCloneCapDev, 1)

                    If m_hCloneCapDev <> 0 Then

                        EXPORTS.QCAP_RUN(m_hCloneCapDev)

                        EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hCloneCapDev, 0)

                    End If

                End If

            End If

        Else

            m_bShowClone = False

            If m_pChannelControl_LIVE.Visible = True Then

                CloneChannelPanel.Visible = False

                If m_hCloneCapDev <> 0 Then

                    EXPORTS.QCAP_STOP(m_hCloneCapDev) : EXPORTS.QCAP_DESTROY(m_hCloneCapDev) : m_hCloneCapDev = 0

                End If

            End If

        End If

    End Sub

    Public Sub OnLButtonDown_ChannelControl(ByVal nChannelNumber As UInt32)

        ' MAXIMIZED THE VIDEO WINDOW
        ' 
        If m_bIsMaximizedForm = True Then

            Me.WindowState = FormWindowState.Normal

            m_pChannelControl_LIVE.Size = New System.Drawing.Size(Me.Width, Me.Height)

            m_bIsMaximizedForm = False

        Else

            Me.WindowState = FormWindowState.Maximized

            m_pChannelControl_LIVE.Size = New System.Drawing.Size(Me.Width, Me.Height)

            m_bIsMaximizedForm = True

        End If

        CloneChannelPanel.Left = Me.Width - 320

        CloneChannelPanel.Top = Me.Height - 240

        CloneChannelPanel.Width = 320

        CloneChannelPanel.Height = 240

    End Sub

    Private Sub Form1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Click

        OnLButtonDown_ChannelControl(0)

    End Sub

    Private Sub timerCheckSignal_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles timerCheckSignal.Tick

        ' DISPLAY FORMAT CHANGED MESSAGE
        '
        If m_bNoSignal = True Then

            labelNoSignal.Visible = True

            labelNoSignal.Left = (Me.Width / 2) - (labelNoSignal.Width / 2)

            labelNoSignal.Top = (Me.Height / 2) - (labelNoSignal.Height / 2)

            m_pChannelControl_LIVE.Visible = False

            m_cSetupControl.m_strFormatChangedOutput = " INFO :  . . ."

        Else

            labelNoSignal.Visible = False

            m_pChannelControl_LIVE.Visible = True

            m_cSetupControl.m_strFormatChangedOutput = m_strFormatChangedOutput

        End If

        m_cSetupControl.m_bNoSignal = m_bNoSignal

    End Sub

End Class
