// StreamCatcherDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sc580.h"
#include "sc580Dlg.h"
#include "VideoQualityDlg.h"
#include "VideoInputDlg.h"
#include "AduioInputDlg.h"
#include <math.h>

#define COMPILE_MULTIMON_STUBS

#include <MULTIMON.H>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}

//  FORMAT CHANGED CALLBACK FUNCTION
//
QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	Dbg("format changed Detected  \n");

	sc580Dlg* m_pMainDialog = (sc580Dlg*)pUserData;

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }


	m_pMainDialog->m_nAudioChannels = nAudioChannels;

	m_pMainDialog->m_nAudioBitsPerSample = nAudioBitsPerSample;

	// OUTPUT FORMAT CHANGED MESSAGE
	//
	CHAR strVideoInput[ MAX_PATH ] = { 0 };

	CHAR strAudioInput[ MAX_PATH ] = { 0 };

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

    UINT nVH = 0;
            
    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }
 	
	if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }
	
	if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}
	
	if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}
	
	if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}
	
    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}
	
	if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}
	
	if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

	m_pMainDialog->m_strFormatChangedOutput.Format( "INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s",

													nVideoWidth,

													nVH,

													strFrameType,

													dVideoFrameRate,

													nAudioChannels,

													nAudioBitsPerSample,

													nAudioSampleFrequency,

													strVideoInput,

													strAudioInput ); 

    // NO SOURCE
    //
    if ( nVideoWidth == 0 && 
		
		 nVideoHeight == 0 &&

		 dVideoFrameRate == 0.0 &&

		 nAudioChannels == 0 &&

		 nAudioBitsPerSample == 0 &&

		 nAudioSampleFrequency == 0 ) {

		m_pMainDialog->m_bNoSignal = TRUE;		
	}
    else {

		m_pMainDialog->m_bNoSignal = FALSE;		
    }
	

    return QCAP_RT_OK;
}    

// NO SIGNAL DETEACTED CALLBACK FUNCTION
//
QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	sc580Dlg* m_pMainDialog = (sc580Dlg*)pUserData;

	Dbg("No Signal Detected  \n");

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDialog->m_bNoSignal = TRUE;

	return QCAP_RT_OK;
}

// SIGNAL REMOVED CALLBACK FUNCTION
//
QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	sc580Dlg* m_pMainDialog = (sc580Dlg*)pUserData;

	Dbg(" Signal Removed \n");

	if ( m_pMainDialog == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDialog->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDialog->m_bNoSignal = TRUE;

    return QCAP_RT_OK;
}    

// PREVIEW VIDEO CALLBACK FUNCTION
//
QRETURN on_process_preview_video_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

double g_d_audio_volume_db_left = 0;

double g_d_audio_volume_db_right = 0;

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	sc580Dlg* m_pMainDialog = (sc580Dlg*)pUserData;

//	Dbg( "on_audio_decoder_file_callback( %f, %d )", dSampleTime, nFrameBufferLen );

	if( m_pMainDialog->m_nAudioBitsPerSample == 16 && 
		
		m_pMainDialog->m_nAudioChannels == 2 ) {

		double  L = 0;

		double  R = 0;

		SHORT * po = (SHORT *)(pFrameBuffer);

		ULONG   samples = nFrameBufferLen / 4; // 16BITS L + R

		for( ULONG i = 0 ; i < samples ; i++ ) {

			L += abs(*po++);

			R += abs(*po++);
		}
		L /= samples;

		R /= samples;

		double DB_L = 20 * log10( L / 32768.0 );

		double DB_R = 20 * log10( R / 32768.0 );

		g_d_audio_volume_db_left = DB_L;

		g_d_audio_volume_db_right = DB_R;
	}

    return QCAP_RT_OK;
}

// VIDEO HARDWARE ENCODER#0 CALLBACK FUNCTION
//
QRETURN on_process_video_hardware_encoder_buffer_0( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, BOOL bIsKeyFrame, PVOID pUserData)
{
    return QCAP_RT_OK;
}

// VIDEO HARDWARE ENCODER#1 CALLBACK FUNCTION
//
QRETURN on_process_video_hardware_encoder_buffer_1( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, BOOL bIsKeyFrame, PVOID pUserData)
{
    return QCAP_RT_OK;
}

/////////////////////////////////////////////////////////////////////////////
// sc580Dlg dialog

sc580Dlg::sc580Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(sc580Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(sc580Dlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void sc580Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(sc580Dlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(sc580Dlg, CDialog)
	//{{AFX_MSG_MAP(sc580Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_CLOSE()
	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// sc580Dlg message handlers

void sc580Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// CDialog::OnOK();
}

void sc580Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	// CDialog::OnCancel();
}

BOOL sc580Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon


	// TODO: Add extra initialization here

	// INITIALIZE MEMBER VARIABLES
	//
	{	m_hVideoDevice = 0;

		m_hCloneCapDev = 0;

		m_nVideoWidth = 0;

		m_nVideoHeight = 0;

		m_bVideoIsInterleaved = FALSE;

		m_dVideoFrameRate = 0.0;

		m_bVideoDeinterlaceEnable = FALSE;

		m_nAudioChannels = 0;

		m_nAudioBitsPerSample = 0;

		m_nAudioSampleFrequency = 0;
		
		m_bNoSignal = TRUE;

		m_bSupportGPU1 = FALSE;
	
		m_bIsRecord1 = FALSE;

		m_bSupportGPU2 = FALSE;
	
		m_bIsRecord2 = FALSE;

		m_bSupportGPU3 = FALSE;
	
		m_bIsRecord3 = FALSE;

		m_nSharpness = 128;

		m_nSaturation = 128;

		m_nHue = 128;

		m_nConstrast = 128;

		m_nBrightness = 128;

		// GET DEFAULT RECORD PATH
		// 
		{	BYTE pData[ MAX_PATH ]; DWORD dwType = REG_SZ; DWORD dwData = MAX_PATH;

			HKEY hKey = NULL; RegOpenKey( HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &hKey );

			RegQueryValueEx( hKey, "Personal", NULL, &dwType, pData, &dwData );

			RegCloseKey( hKey );

			CHAR psz[ MAX_PATH ] = "";

			if ( strlen( (CHAR*)(pData) ) ) {

				m_strDefaultPath.Format( "%s", (CHAR*)(pData) );
			}
			else {

				m_strDefaultPath.Format( "%s", "" );
			}
			m_strSnapshotPath.Format( "%s\\My Snapshots", m_strDefaultPath );

			m_strRecordPath.Format( "%s\\My Records", m_strDefaultPath );

			CreateDirectory( m_strSnapshotPath, NULL );

			CreateDirectory( m_strRecordPath, NULL );
		}

		m_strRecordFileName = "";
	}
	// INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// INITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows[ 0 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE, CRect( 20, 0, 960, 540 ), this, 0x00000001, NULL ); // VIDEO WINDOW

		m_oChannelWindows[ 1 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE, CRect( 20, 0, 960, 540 ), this, 0x00000002, NULL ); // BACKGROUND WINDOW

		m_oCloneWindows.Create( NULL, "MyCloneWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 0, 0 ), this, 0x10000001, NULL ); // BACKGROUND WINDOW

		// INITIALIZE MAIN WINDOW
		//
		{	CRect oWindowRect; GetWindowRect( &oWindowRect );

			CRect oClientRect; GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			MoveWindow( 0, 0, cx + 960 + 20 + 20, cy + 540 );

			m_oChannelWindows[ 0 ].MoveWindow( 20, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 1 ].MoveWindow( 20, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 1 ].ShowWindow( FALSE );

			m_oCloneWindows.MoveWindow( cx + 960 - 320 + 20, cy + 540 - 240, 320, 240 );

			m_oCloneWindows.ShowWindow( FALSE );
		}

		// INITIALIZE SETUP DIALOG
		//
		{				
			HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );			

			MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 
			
			GetMonitorInfo( hMonitor, &sMonitorInfo );

			CRect oMonitorRect = sMonitorInfo.rcWork;			
			
			m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

			CRect oWindowRect; m_oSetupDialog.GetWindowRect( &oWindowRect );

			CRect oClientRect; m_oSetupDialog.GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), (oMonitorRect.Width() - (960 + cx)) / 2,

														  (oMonitorRect.Height() - (105 + 40 + cy)),
														  
														  (cx + 960), 

														  (cy + 350),
														  
														  (NULL) );
			m_oSetupDialog.ShowWindow( TRUE );
		}
//
//	INITIALIZE CTRL
//
		{
		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		ULONG n_pro_l_cy = 0;
		ULONG n_pro_l_cx = 0;
		ULONG n_pro_l_width = 20;
		ULONG n_pro_l_height = cy + 540;

		m_progAudioVolumeDBBar_L.Create( WS_CHILD | WS_VISIBLE | WS_BORDER | PBS_VERTICAL , CRect(0, 0, 0, 0), this, 0x80000001 );
		m_progAudioVolumeDBBar_L.MoveWindow( n_pro_l_cx, n_pro_l_cy, n_pro_l_width, n_pro_l_height );

		ULONG n_pro_r_cy = 0;
		ULONG n_pro_r_cx = 20 + cx + 960;
		ULONG n_pro_r_width = 20;
		ULONG n_pro_r_height = cy + 540;
	  	m_progAudioVolumeDBBar_R.Create( WS_CHILD | WS_VISIBLE | WS_BORDER | PBS_VERTICAL , CRect(0, 0, 0, 0), this, 0x80000002 );
		m_progAudioVolumeDBBar_R.MoveWindow( n_pro_r_cx, n_pro_r_cy, n_pro_r_width, n_pro_r_height );

		m_progAudioVolumeDBBar_L.SetRange( 0, 100 );
		m_progAudioVolumeDBBar_R.SetRange( 0, 100 );
		}
		SetWindowText( "" DEFAULT_PRODUCT ", " DEFAULT_PRODUCT_VERSION );
	}

	HwInitialize();	

	SetTimer( 0x00000003, 100, NULL );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void sc580Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else {

		CDialog::OnPaint();
	}
}

HCURSOR sc580Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL sc580Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	CRect rect_client;	GetClientRect( &rect_client );

	CBrush brush_fill_rect(RGB(0, 0, 0));

	pDC->FillRect( &rect_client, &brush_fill_rect );

	return CWnd::OnEraseBkgnd(pDC);
}

BOOL sc580Dlg::OnLButtonDblClk_ChannelWindow() 
{
	// TODO: Add your message handler code here and/or call default
	
	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );	

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 

	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcMonitor;

	CRect oWindowRect; GetWindowRect( &oWindowRect );

	if ( oWindowRect.Width() < oMonitorRect.Width() ) {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		m_oCloneWindows.MoveWindow( oMonitorRect.Width() - 320, oMonitorRect.Height() - 240, 320, 240 );

		MoveWindow( oMonitorRect );
	}
	else {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, 960, 540 );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, 960, 540 );

		m_oCloneWindows.MoveWindow( 960 - 320, 540 - 240, 320, 240 );

		MoveWindow( (oMonitorRect.Width() - 960) / 2, (oMonitorRect.Height() - 540) / 2, 960, 540 );	
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonVideoInput_SetupDialog() 

{
	// TODO: Add your control notification handler code here

	if( m_hVideoDevice == 0 ) { return FALSE; }

	CVideoInputDlg dlg;

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL sc580Dlg::OnButtonAudioInput_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	if( m_hVideoDevice == 0 ) { return FALSE; }

	CAduioInputDlg dlg(this);

	INT_PTR nResponse = -1;
	
	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL sc580Dlg::OnButtonVideoQuality_SetupDialog() 
{
	// TODO: Add your control notification handler code here
	
	if( m_hVideoDevice == 0 ) { return FALSE; }

	CVideoQualityDlg dlg(this);

	INT_PTR nResponse = -1;

	nResponse = dlg.DoModal();

	return TRUE;
}

BOOL sc580Dlg::OnCheckAutoDeinterlace_SetupDialog() 
{
	// TODO: Add your control notification handler code here

	if ( m_oSetupDialog.m_checkAutoDeinterlace.GetCheck() == TRUE ) {

		m_bVideoDeinterlaceEnable = TRUE;
	}
	else {

		m_bVideoDeinterlaceEnable = FALSE;
	}

    if ( m_hVideoDevice != 0 ) {

		if ( m_bVideoDeinterlaceEnable ) {

			QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice, 1 );
		}		
        else {

		    QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice, 0 );
		}        
    }

	return TRUE;
}

BOOL sc580Dlg::OnCheckShowCloneVideo_SetupDialog()
{
	if ( m_oSetupDialog.m_btnShowCloneVideo.GetCheck() == TRUE ) {

		m_oChannelWindows[ 0 ].SetParent( CWnd::GetDesktopWindow() );

		m_oChannelWindows[ 1 ].SetParent( CWnd::GetDesktopWindow() );

		m_oCloneWindows.SetParent( CWnd::GetDesktopWindow() );

		m_oChannelWindows[ 0 ].SetParent( this );

		m_oChannelWindows[ 1 ].SetParent( this );

		m_oCloneWindows.SetParent( this );

		m_oCloneWindows.ShowWindow( TRUE );		

		if ( m_hVideoDevice != 0 ) {

			QCAP_CREATE_CLONE( m_hVideoDevice, m_oCloneWindows.GetSafeHwnd(), &m_hCloneCapDev, 1 );

			if ( m_hCloneCapDev != 0 ) {

				QCAP_RUN( m_hCloneCapDev );

				QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev, 0 );
			}

		}

	}
	else {

		m_oCloneWindows.ShowWindow( FALSE );

		if ( m_hCloneCapDev != 0 ) {

			QCAP_STOP( m_hCloneCapDev );

			QCAP_DESTROY( m_hCloneCapDev );

			m_hCloneCapDev = 0;
		}
	}    
	return TRUE;
}

BOOL sc580Dlg::OnButtonSnapshotJPG_SetupDialog() 
{
	if( m_hVideoDevice != 0 ) {

		CString strFullPathName;

		strFullPathName = m_strSnapshotPath + _T("\\unname.jpg");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen + 1 );

        QCAP_SNAPSHOT_JPG( m_hVideoDevice, psz, 100 );

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonSnapshotBMP_SetupDialog() 
{
	if ( m_hVideoDevice != 0 ) {

		CString strFullPathName;

		strFullPathName = m_strSnapshotPath + _T("\\unname.bmp");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen + 1 );

        QCAP_SNAPSHOT_BMP( m_hVideoDevice, psz );

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonRecordStart1_1_SetupDialog()
{
	m_oSetupDialog.m_btnRecordStart_1_1.EnableWindow( FALSE ); 

	m_oSetupDialog.m_btnRecordStop_1_1.EnableWindow( TRUE ); 

	m_bSupportGPU1 = m_oSetupDialog.m_checkGPU_1_1.GetCheck();

	if ( m_hVideoDevice != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = m_oSetupDialog.IsDlgButtonChecked( IDC_AVI_1_RADIO );

		iCheckedMP4 = m_oSetupDialog.IsDlgButtonChecked( IDC_MP4_1_RADIO );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_strRecordPath + _T("\\unname1_1080_12M.avi");
		}
        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_strRecordPath + _T("\\unname1_1080_12M.mp4");
		}		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

//		QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_hVideoDevice, 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ); // MOVE TO HWINITIALIZE()

		QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF);

		QCAP_START_RECORD( m_hVideoDevice, 0, psz);

		m_bIsRecord1 = true;

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonRecordStop1_1_SetupDialog()
{
	m_oSetupDialog.m_btnRecordStart_1_1.EnableWindow( TRUE ); 

	m_oSetupDialog.m_btnRecordStop_1_1.EnableWindow( FALSE ); 

	if ( m_hVideoDevice != 0 ) {

		QCAP_STOP_RECORD( m_hVideoDevice, 0 );

		m_bIsRecord1 = false;
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonRecordStart1_2_SetupDialog()
{
	m_oSetupDialog.m_btnRecordStart_1_2.EnableWindow( FALSE ); 

	m_oSetupDialog.m_btnRecordStop_1_2.EnableWindow( TRUE ); 

	m_bSupportGPU2 = m_oSetupDialog.m_checkGPU_1_2.GetCheck();

	if ( m_hVideoDevice != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = m_oSetupDialog.IsDlgButtonChecked( IDC_AVI_2_RADIO );

		iCheckedMP4 = m_oSetupDialog.IsDlgButtonChecked( IDC_MP4_2_RADIO );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_strRecordPath + _T("\\unname2_480_6M.avi");
		}
        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_strRecordPath + _T("\\unname2_480_6M.mp4");
		}		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

	//	QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_hVideoDevice, 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ); // MOVE TO HWINITIALIZE()

		QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 1, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

		QCAP_START_RECORD( m_hVideoDevice, 1, psz);

		m_bIsRecord2 = true;

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonRecordStop1_2_SetupDialog()
{
	m_oSetupDialog.m_btnRecordStart_1_2.EnableWindow( TRUE ); 

	m_oSetupDialog.m_btnRecordStop_1_2.EnableWindow( FALSE ); 

	if ( m_hVideoDevice != 0 ) {

		QCAP_STOP_RECORD( m_hVideoDevice, 1 );

		m_bIsRecord2 = FALSE;
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonRecordStart1_3_SetupDialog()
{
	m_oSetupDialog.m_btnRecordStart_1_3.EnableWindow( FALSE ); 

	m_oSetupDialog.m_btnRecordStop_1_3.EnableWindow( TRUE ); 

	m_bSupportGPU3 = m_oSetupDialog.m_checkGPU_1_3.GetCheck();

	if ( m_hVideoDevice != 0 ) {

		CString strFullPathName;

		UINT iCheckedAVI, iCheckedMP4;

		iCheckedAVI = m_oSetupDialog.IsDlgButtonChecked( IDC_AVI_3_RADIO );

		iCheckedMP4 = m_oSetupDialog.IsDlgButtonChecked( IDC_MP4_3_RADIO );

		if ( iCheckedAVI == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_PCM );

			strFullPathName = m_strRecordPath + _T("\\unname3_240_2M.avi");
		}
        if ( iCheckedMP4 == BST_CHECKED ) {

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC );

			strFullPathName = m_strRecordPath + _T("\\unname3_240_2M.mp4");
		}

		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

		if ( m_bSupportGPU3 ) {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_4 );

			QCAP_START_RECORD( m_hVideoDevice, 2, psz );			
		}
		else {

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice, 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_4 );

			QCAP_START_RECORD( m_hVideoDevice, 2, psz );
		}

		m_bIsRecord3 = true;

		strFullPathName.ReleaseBuffer();
	}

	return TRUE;
}

BOOL sc580Dlg::OnButtonRecordStop1_3_SetupDialog()
{
	m_oSetupDialog.m_btnRecordStart_1_3.EnableWindow( TRUE ); 

	m_oSetupDialog.m_btnRecordStop_1_3.EnableWindow( FALSE ); 

	if ( m_hVideoDevice != 0 ) {

		QCAP_STOP_RECORD( m_hVideoDevice, 2 );

		m_bIsRecord3 = false;
	}
	
	return TRUE;
}

void sc580Dlg::OnDestroy() 
{
	KillTimer( 0x00000001 );

	// UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUninitialize();
	}
	// UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows[ 0 ].DestroyWindow();

		m_oChannelWindows[ 1 ].DestroyWindow();

		m_oSetupDialog.DestroyWindow();
	}
	// UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
}

BOOL sc580Dlg::HwInitialize()
{
	// CALLBACK FUNCTION
	//        
	PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB = { 0 };

	PF_VIDEO_PREVIEW_CALLBACK  m_pPreviewVideoCB = { 0 };

	PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB = { 0 };

	PF_VIDEO_HARDWARE_ENCODER_CALLBACK m_pHardwareEncoderVideoCB_0 = { 0 };

	PF_VIDEO_HARDWARE_ENCODER_CALLBACK m_pHardwareEncoderVideoCB_1 = { 0 };

	PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB = { 0 };

	PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB = { 0 };

	// CREATE CAPTURE DEVICE
	//
	QCAP_CREATE( "MZ0380 PCI", 0, m_oChannelWindows[ 0 ].m_hWnd, &m_hVideoDevice, 1 );

    if ( m_hVideoDevice == 0 ) { return false;  }       	

    // REGISTER FORMAT CHANGED CALLBACK FUNCTION
    // 
    m_pFormatChangedCB = on_process_format_changed;

    QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice, m_pFormatChangedCB, this );

    // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
    // 
    m_pPreviewVideoCB = on_process_preview_video_buffer;

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice, m_pPreviewVideoCB, this );

    // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
    //
    m_pPreviewAudioCB = on_process_preview_audio_buffer;

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice, m_pPreviewAudioCB, this );
	
    // REGISTER VIDEO HARDWARE ENCODER#0 CALLBACK FUNCTION
    // 
    m_pHardwareEncoderVideoCB_0 = on_process_video_hardware_encoder_buffer_0;

    QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_hVideoDevice, 0, m_pHardwareEncoderVideoCB_0, this );

    // REGISTER VIDEO HARDWARE ENCODER#1 CALLBACK FUNCTION
    // 
    m_pHardwareEncoderVideoCB_1 = on_process_video_hardware_encoder_buffer_1;

    QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_hVideoDevice, 1, m_pHardwareEncoderVideoCB_1, this );

	// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
	//
	m_pNoSignalDetectedCB = on_process_no_signal_detected;

	QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice, m_pNoSignalDetectedCB, this );

	// REGISTER SIGNAL REMOVED CALLBACK FUNCTION
	//
	m_pSignalRemovedCB =  on_process_signal_removed;

	QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice, m_pSignalRemovedCB, this );

    QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice, 0);

	QCAP_SET_AUDIO_VOLUME( m_hVideoDevice, 100);

//	QCAP_SET_OSD_TEXT( m_hVideoDevice, 0,  10,  10,  -1,  -1, "SC510N1 OSD DEMO#1\nMULTIPLE LINES", "Arial", QCAP_FONT_STYLE_BOLD, 24, 0xFFFFFFFF, 0x80800000, 0xFF );

//	QCAP_SET_OSD_TEXT( m_hVideoDevice, 1, 500, 500, 100, 100, "SC510N1 OSD DEMO#2", "Arial", QCAP_FONT_STYLE_BOLD, 24, 0xFFFFFFFF, 0x80008000, 0xC0 );

//	QCAP_SET_OSD_PICTURE( m_hVideoDevice, 2, 400,  10,  -1,  -1, "YUAN.PNG", 0xFF );

//	QCAP_SET_OSD_PICTURE( m_hVideoDevice, 3, 600,  10,  -1,  -1, "YUAN.JPG", 0xC0 );

//	QCAP_SET_OSD_PICTURE( m_hVideoDevice, 4, 800,  10, 150, 150, "YUAN.BMP", 0x80 );

//	CHAR psz[ MAX_PATH ] = "C:\\OSD.TEXT.TXT";

//	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_hVideoDevice, 921, (BYTE *)(psz), strlen(psz) );

//	ULONG params[ 4 ] = { 0, 10, 10, 255 };

//	CHAR psz[ MAX_PATH ] = "D:\\LOGO.BMP";

//	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_hVideoDevice, 970, (BYTE *)(params), sizeof(params) );

//	QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX( m_hVideoDevice, 971, (BYTE *)(psz), strlen(psz) );
	
	QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_hVideoDevice, 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );

	QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX( m_hVideoDevice, 1, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_PROFILE_MAIN, QCAP_RECORD_LEVEL_41, QCAP_RECORD_ENTROPY_CABAC, QCAP_RECORD_MODE_CBR, 8000,  6 * 1024 * 1024, 30, 0, FALSE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );

	QCAP_RUN( m_hVideoDevice );	
  
	SetTimer( 0x00000001, 1000, NULL );

	SetTimer( 0x00000002, 1000, NULL );
 
	// UPDATE USER INTERFACE RESOURCE
	//
	if ( m_hVideoDevice == 0 ) { 

		m_oSetupDialog.m_btnVideoInput.EnableWindow( FALSE );

		m_oSetupDialog.m_btnVideoQuality.EnableWindow( FALSE );

		m_oSetupDialog.m_btnAudioInput.EnableWindow( FALSE );
		
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStart_1_1.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStop_1_1.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStart_1_2.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStop_1_2.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStart_1_3.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStop_1_3.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU_1_1.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU_1_1.SetCheck( 0 );

		m_oSetupDialog.m_checkGPU_1_2.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU_1_2.SetCheck( 0 );

		m_oSetupDialog.m_checkGPU_1_3.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU_1_3.SetCheck( 0 );

		m_oSetupDialog.m_checkAutoDeinterlace.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkAutoDeinterlace.SetCheck( 0 );

	}
	else {
			
		m_oSetupDialog.m_btnSnapshot_bmp.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnSnapshot_jpg.EnableWindow( TRUE);

		m_oSetupDialog.m_btnRecordStart_1_1.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnRecordStop_1_1.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStart_1_2.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnRecordStop_1_2.EnableWindow( FALSE ); 

		m_oSetupDialog.m_btnRecordStart_1_3.EnableWindow( TRUE ); 

		m_oSetupDialog.m_btnRecordStop_1_3.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU_1_1.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU_1_1.SetCheck( 0 );

		m_oSetupDialog.m_checkGPU_1_2.EnableWindow( FALSE ); 

		m_oSetupDialog.m_checkGPU_1_2.SetCheck( 0 );

		m_oSetupDialog.m_checkGPU_1_3.EnableWindow( TRUE ); 

		m_oSetupDialog.m_checkGPU_1_3.SetCheck( 0 );

		m_oSetupDialog.m_checkAutoDeinterlace.EnableWindow( TRUE ); 

		m_oSetupDialog.m_checkAutoDeinterlace.SetCheck( 0 );
	}	

	return TRUE;
}

BOOL sc580Dlg::HwUninitialize()
{
	if ( m_hCloneCapDev != 0 ) {

		QCAP_STOP( m_hCloneCapDev );

		QCAP_DESTROY( m_hCloneCapDev );

		m_hCloneCapDev = NULL;
	}
	if ( m_hVideoDevice != 0 ) {

		QCAP_STOP( m_hVideoDevice );

		QCAP_DESTROY( m_hVideoDevice );

		m_hVideoDevice = NULL;
	}
	return TRUE;
}

void sc580Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	if( nIDEvent == 0x00000001 ) {

		if( m_hVideoDevice ) {

			int L = (int)(100.0 +  g_d_audio_volume_db_left); if( L < 0 ) { L = 0; }

			int R = (int)(100.0 + g_d_audio_volume_db_right); if( R < 0 ) { R = 0; }

			m_progAudioVolumeDBBar_L.SetPos( L );

			m_progAudioVolumeDBBar_R.SetPos( R );
		}
	}
	
	if ( nIDEvent == 0x00000001 ) {

		if ( m_hVideoDevice == NULL ) { return ; }

        if ( m_bIsRecord1 && m_bNoSignal ) { 

			QCAP_STOP_RECORD( m_hVideoDevice, 0 );

			m_bIsRecord1 = false;
		}
		if ( m_bIsRecord2 && m_bNoSignal ) {

			QCAP_STOP_RECORD( m_hVideoDevice, 1 );

			m_bIsRecord2 = false;
		}
		if ( m_bIsRecord3 && m_bNoSignal ) {

			QCAP_STOP_RECORD( m_hVideoDevice, 2 );

			m_bIsRecord3 = false;
		}
	}

	if( nIDEvent == 0x00000002 ) {

		if ( m_bNoSignal ) {

			m_oSetupDialog.m_staticDeviceFormatInformation.SetWindowText( _T("INFO :...") );

			m_oChannelWindows[ 0 ].ShowWindow( FALSE );

			m_oChannelWindows[ 1 ].ShowWindow( TRUE );				
		}
		else {

			m_oSetupDialog.m_staticDeviceFormatInformation.SetWindowText( (LPCTSTR)m_strFormatChangedOutput );

			m_oChannelWindows[ 0 ].ShowWindow( TRUE );

			m_oChannelWindows[ 1 ].ShowWindow( FALSE );			
		}
	}

	CDialog::OnTimer(nIDEvent);
}

void sc580Dlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CWnd::OnLButtonDown(nFlags, point);	
	
	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x, point.y ) );
}
